#pragma once

#include "ping_context.h"

#include <balancer/kernel/coro/coroutine.h>

namespace NBalancerClient {
class TPinger {
  public:
    struct TOptions {
        TContExecutor* ContExecutor = nullptr;
        TDuration TimeWithoutDataBeforePing = TDuration::Seconds(1);
    };

    TPinger(TOptions options);

    void Shedule(TPingContext& pingContext);
    void Cancel();
  private:
    TContExecutor& Executor() const;
    void Start();

    TOptions Options_;
    TIntrusiveList<TPingContext> Contexts_;
    NSrvKernel::TCoroutine Coroutine_;
};
} // namespace NBalancerClient
