#include "http2_common.h"

namespace NSrvKernel::NHTTP2 {

    // TUnitedChunkList ================================================================================================

    TUnitedChunkList::TUnitedChunkList(const TChunkList& lst) noexcept
    {
        const auto sz = lst.ChunksCount();
        if (sz > 1) {
            Copy(lst);
        } else if (sz == 1) {
            DataView_ = lst.Front()->AsStringBuf();
        }
    }

    TUnitedChunkList::TUnitedChunkList(TChunkList&& lst) noexcept
    {
        Copy(lst);
        lst.Clear();
    }

    void TUnitedChunkList::Copy(const TChunkList& lst) noexcept {
        const auto len = lst.size();
        THolder<TChunkData> dataPtr = NewChunkData(len);
        lst.CopyDataTo(dataPtr->Data(), len);
        Data_ = TBlob(dataPtr->Data(), len, dataPtr.Release());
        DataView_ = TStringBuf(Data_->AsCharPtr(), Data_->Length());
    }
}
