#pragma once

#include "http2_common.h"

#include <balancer/kernel/memory/chunks.h>

namespace NSrvKernel::NHTTP2 {

    [[nodiscard]] bool IsRequestHeaderSpecial(TStringBuf name) noexcept;

    [[nodiscard]] bool IsRequestHeaderSpecial(const TChunkList& name) noexcept;

    [[nodiscard]] bool IsResponseHeaderSpecial(const TChunkList& name) noexcept;

    [[nodiscard]] bool IsResponseHeaderSpecial(const TStringBuf name) noexcept;

    [[nodiscard]] bool IsHeaderProhibited(const TChunkList& name) noexcept;

    [[nodiscard]] bool IsHeaderProhibited(TStringBuf name) noexcept;

    [[nodiscard]] bool IsHeaderProhibited(const TChunkList& name) noexcept;

    [[nodiscard]] bool IsRequestHeaderNameValid(const TChunkList& name) noexcept;

    [[nodiscard]] bool IsResponseHeaderNameValid(const TStringBuf name) noexcept;

    [[nodiscard]] bool IsRequestHeaderValueValid(const TChunkList& value) noexcept;

    [[nodiscard]] bool IsValueHighPrioContentType(TStringBuf contentType) noexcept;

    [[nodiscard]] bool IsValueHighPrioContentType(const TChunkList& contentType) noexcept;

    [[nodiscard]] bool IsXYandexH2PrioEdge(TStringBuf name) noexcept;

    [[nodiscard]] bool IsContentType(TStringBuf name) noexcept;

    [[nodiscard]] bool IsTransferEncoding(const TChunkList& name) noexcept;

    [[nodiscard]] bool IsTransferEncoding(TStringBuf name) noexcept;

    void InitHeadersFSMs() noexcept;
}
