import collections
import re

from gen_utils import project_dir, read_file


def parse_rfc7541_static_table():
    StaticCode = collections.namedtuple("StaticCode", ['index', 'name', 'value'])
    code_regex = re.compile("^(?P<index>\\d+) +(?P<name>[^ ]+)(?: +(?P<value>.+))?$")
    result = []
    for line in read_file(project_dir("static.txt")).split('\n'):
        line = line.strip()
        if not line:
            continue
        match = code_regex.search(line)
        if not match:
            print(line)
            continue
        result.append(StaticCode(
            index=int(match.group('index')),
            name=match.group('name'),
            value=match.group('value')
        ))

    if len(result) != 61:
        raise Exception("bad parse: {}".format(len(result)))

    return result
