#include "hpack_definitions.h"

#include <util/string/builder.h>

namespace NSrvKernel::NHTTP2 {
#define HPACK_WRITE_FIELD(str, field) (str) << #field << ':' << (field)

    TString THPackDecoderSettings::ToString() const noexcept {
        TStringBuilder str;
        str << '{';
        HPACK_WRITE_FIELD(str, MaxHeaderTableSize) << ',';
        HPACK_WRITE_FIELD(str, MaxHeaderListSize) << ',';
        HPACK_WRITE_FIELD(str, MaxHeadersCount) << ',';
        str << '}';
        return str;
    }

    TString THPackEncoderSettings::ToString() const noexcept {
        TStringBuilder str;
        str << '{';
        HPACK_WRITE_FIELD(str, MaxHeaderTableSize) << ',';
        HPACK_WRITE_FIELD(str, MaxFrameSize) << ',';
        HPACK_WRITE_FIELD(str, EnableHuffman);
        str << '}';
        return str;
    }

    size_t THeaderFieldView::Hash() const noexcept {
        return THash<decltype(AsTuple())>()(AsTuple());
    }

    bool THeaderFieldView::operator==(const THeaderFieldView& other) const noexcept {
        return AsTuple() == other.AsTuple();
    }
}
