#pragma once

#include <util/system/types.h>

#include <array>

namespace NSrvKernel::NHTTP2 {
    const size_t HUFFMAN_MIN_LENGTH = 5;
    const size_t HUFFMAN_MAX_LENGTH = 30;

    struct THuffmanChar {
        ui32 Code = 0;
        ui32 Length = 0;

        THuffmanChar(ui32 code, ui32 len) noexcept
            : Code(code)
            , Length(len)
        {}
    };

    using THuffmanEncodingTable = THuffmanChar[256];

    extern const THuffmanEncodingTable HUFFMAN_ENCODING_TABLE;

    extern const THuffmanEncodingTable HUFFMAN_ENCODING_TABLE_LOWER_CASE;

    struct THuffmanState {
        ui8 NextState = 0;
        bool IsEmitting = 0;
        ui8 Symbol = 0;
        bool IsFinal = 0;

        THuffmanState(ui8 nextState, bool isEmitting, ui8 symbol, bool isFinal) noexcept
            : NextState(nextState)
            , IsEmitting(isEmitting)
            , Symbol(symbol)
            , IsFinal(isFinal)
        {}
    };

    using THuffmanStateEdges = THuffmanState[16];
    using THuffmanDecodingFST = THuffmanStateEdges[256];

    extern const THuffmanDecodingFST HUFFMAN_DECODING_FST;
};
