#pragma once

#include "hpack_definitions.h"
#include "hpack_strings.h"

#include <balancer/kernel/http/parser/http.h>
#include <balancer/kernel/memory/chunks.h>

#include <util/system/compiler.h>
#include <util/system/types.h>

namespace NSrvKernel::NHTTP2 {
    // The user is forced to combine all the header continuations before parsing the header block.
    // The TChunk objects are too heavy to allow big lists of them. And the logic is simplier.
    class THPackReader {
    public:
        explicit THPackReader(TInputRegion headerBlock) noexcept;

        [[nodiscard]] bool HasNext() const noexcept {
            return HeaderBlock_.SizeAvailable();
        }

        [[nodiscard]] bool HasTableSizeUpdate() const noexcept;

        TErrorOr<ui32> ReadTableSizeUpdate() noexcept;

        TErrorOr<EHeaderFieldType> PeekNextHeaderFieldType() const noexcept;

        TErrorOr<ui32> ReadNextHeaderFieldIndex(EHeaderFieldType) noexcept;

        TErrorOr<TChunkPtr> ReadString(THPackLimits& limits) noexcept;

    private:
        TErrorOr<TChunkPtr> DoReadStringRaw(THPackLimits& limits, ui32 length) noexcept;

        TErrorOr<TChunkPtr> DoReadStringHuffman(THPackLimits& limits, ui32 length) noexcept;

    private:
        TInputRegion HeaderBlock_;
    };
}
