#include "hpack_static_table.h"

namespace NSrvKernel::NHTTP2 {

    TStaticTable::TStaticTable() noexcept
        : StaticTable_{
        { REQ_HEADER_AUTHORITY, "" },
        { REQ_HEADER_METHOD, "GET" },
        { REQ_HEADER_METHOD, "POST" },
        { REQ_HEADER_PATH, "/" },
        { REQ_HEADER_PATH, "/index.html" },
        { REQ_HEADER_SCHEME, "http" },
        { REQ_HEADER_SCHEME, "https" },
        { RESP_HEADER_STATUS, "200" },
        { RESP_HEADER_STATUS, "204" },
        { RESP_HEADER_STATUS, "206" },
        { RESP_HEADER_STATUS, "304" },
        { RESP_HEADER_STATUS, "400" },
        { RESP_HEADER_STATUS, "404" },
        { RESP_HEADER_STATUS, "500" },
        { "accept-charset", "" },
        { "accept-encoding", "gzip, deflate" },
        { "accept-language", "" },
        { "accept-ranges", "" },
        { "accept", "" },
        { "access-control-allow-origin", "" },
        { "age", "" },
        { "allow", "" },
        { "authorization", "" },
        { "cache-control", "" },
        { "content-disposition", "" },
        { "content-encoding", "" },
        { "content-language", "" },
        { "content-length", "" },
        { "content-location", "" },
        { "content-range", "" },
        { "content-type", "" },
        { "cookie", "" },
        { "date", "" },
        { "etag", "" },
        { "expect", "" },
        { "expires", "" },
        { "from", "" },
        { "host", "" },
        { "if-match", "" },
        { "if-modified-since", "" },
        { "if-none-match", "" },
        { "if-range", "" },
        { "if-unmodified-since", "" },
        { "last-modified", "" },
        { "link", "" },
        { "location", "" },
        { "max-forwards", "" },
        { "proxy-authenticate", "" },
        { "proxy-authorization", "" },
        { "range", "" },
        { "referer", "" },
        { "refresh", "" },
        { "retry-after", "" },
        { "server", "" },
        { "set-cookie", "" },
        { "strict-transport-security", "" },
        { "transfer-encoding", "" },
        { "user-agent", "" },
        { "vary", "" },
        { "via", "" },
        { "www-authenticate", "" },
    }
    {
        Y_VERIFY(StaticTable_.size() == RFC_STATIC_TABLE_INDEX_MAX, "invalid static table");

        for (size_t idx = 0, sz = StaticTable_.size(); idx < sz; ++idx) {
            const auto headerField = StaticTable_[idx];
            const THeaderFieldView headerFieldName{headerField.Name};
            if (!HeaderFieldIndexes_.contains(headerFieldName)) {
                HeaderFieldIndexes_[headerFieldName] = idx + 1;
            }
            HeaderFieldIndexes_[headerField] = idx + 1;
        }
    }

    THeaderFieldView TStaticTable::GetHeaderField(ui32 idx) const noexcept {
        Y_VERIFY(idx > 0 && idx <= RFC_STATIC_TABLE_INDEX_MAX);
        return StaticTable_.at(idx - 1);
    }

    ui32 TStaticTable::GetHeaderFieldIndex(THeaderFieldView headerField) const noexcept {
        if (const auto* ptr = HeaderFieldIndexes_.FindPtr(headerField)) {
            return *ptr;
        } else {
            return 0;
        }
    }

    const TStaticTable& TStaticTable::Instance() noexcept {
        return Default<TStaticTable>();
    }
}
