#pragma once

#include "hpack_definitions.h"

#include <util/generic/hash.h>
#include <util/generic/vector.h>

namespace NSrvKernel::NHTTP2 {

    class TStaticTable : TNonCopyable {
    public:
        TStaticTable() noexcept;

        [[nodiscard]] THeaderFieldView GetHeaderField(ui32 idx) const noexcept;

        [[nodiscard]] ui32 GetHeaderFieldIndex(THeaderFieldView headerField) const noexcept;

        static const TStaticTable& Instance() noexcept;

    private:
        THashMap<THeaderFieldView, ui32, THashOf<THeaderFieldView>, TEqualTo<THeaderFieldView>> HeaderFieldIndexes_;
        TVector<THeaderFieldView> StaticTable_;
    };

}
