#pragma once

#include "hpack_definitions.h"

namespace NSrvKernel::NHTTP2 {

    // The huffman implementation is a copypaste from nginx with only minor modifications.
    // The nginx got it quite right so we had no practical reason to reimplement it.

    // Calculates the exact size the huffman encoded string will occupy.
    [[nodiscard]] size_t GetHuffmanEncodedStringSize(TStringBuf decodedStr) noexcept;

    // Calculates the exact size the huffman encoded lower case string will occupy.
    [[nodiscard]] size_t GetHuffmanEncodedLowerCaseStringSize(TStringBuf decodedStr) noexcept;

    // Gives the lower bound of the size the huffman decoded string will occupy.
    [[nodiscard]] size_t GetMinHuffmanDecodedStringSize(size_t encodedSize) noexcept;

    // Gives the upper bound of the size the huffman decoded string will occupy.
    [[nodiscard]] size_t GetMaxHuffmanDecodedStringSize(size_t encodedSize) noexcept;

    // Encodes the input string with huffman. Shifts the output past the data.
    void HuffmanEncodeString(TStringBuf input, TOutputRegion& output) noexcept;

    // Encodes the input string with huffman, lowering its case. Shifts the output past the data.
    void HuffmanEncodeStringLowerCase(TStringBuf input, TOutputRegion& output) noexcept;

    // Decodes the huffman encoded input string. On success shifts the output past the data.
    TError HuffmanDecodeString(TStringBuf input, TOutputRegion& output) noexcept;

    // Copies the input string to the output. Shifts the output past the data.
    void CopyString(TStringBuf input, TOutputRegion& output) noexcept;

    // Copies the input string to the output, lowering its case. Shifts the output past the data.
    void CopyStringLowerCase(TStringBuf input, TOutputRegion& output) noexcept;
}
