#pragma once

#include "http2_settings.h"
#include "http2_stats.h"

#include <balancer/kernel/helpers/errors.h>

namespace NSrvKernel {
    class TModuleParams;
    class IModule;
    class TConnDescr;
}

namespace NSrvKernel::NHTTP2 {

    [[nodiscard]] TSettings GetDefaultServerSettings() noexcept;

    class IHTTP2Module {
    public:
        IHTTP2Module() noexcept;

        virtual ~IHTTP2Module() = default;

        virtual const TModuleParams& GetModuleParams() const noexcept = 0;

        virtual const IModule& GetNextModule() const noexcept = 0;

        virtual TStats& GetStats(const TConnDescr& descr) const noexcept = 0;

        virtual TStringBuf GetModuleName() const noexcept = 0;

        TError OnConnection(
            const TConnDescr& descr,
            TLog* debugLog,
            const TSettings& serverSettings,
            const TAuxServerSettings& auxServerSettings
        ) const;

        TError OnHTTP(const TConnDescr& descr) const;
    };

}
