#pragma once

#include "http2_base.h"
#include "http2_frame.h"
#include "http2_settings.h"
#include "http2_stats.h"

#include <library/cpp/coroutine/engine/impl.h>

#include <balancer/kernel/custom_io/iterator.h>
#include <balancer/kernel/http2/server/common/http2_common.h>
#include <balancer/kernel/http2/server/utils/http2_log.h>

#include <balancer/kernel/io/iobase.h>

namespace NSrvKernel::NHTTP2 {

    constexpr TStringBuf HTTP2_PREFACE = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n";

    class TConnInput {
    public:
        explicit TConnInput(
            IIoInput& input,
            TLogger& logger,
            TStats& stats,
            const TServerSettings& serverSettings
        ) noexcept;

        TErrorOr<bool> RecvPreface() noexcept;

        TErrorOr<TMaybe<TFrame>> RecvFrame() noexcept;

    private:
        TErrorOr<bool> Peek() noexcept;

        TError ValidateFrameHeading(const TFrameHeading& heading) const noexcept;

    private:
        TLogger& Logger_;
        TStats& Stats_;
        const TServerSettings& ServerSettings_;

        TStreamIterator Input_;
    };
}
