#pragma once

#include "http2_frame.h"
#include "http2_settings.h"

namespace NSrvKernel::NHTTP2 {

    class TEdgePrioFix {
    public:
        TEdgePrioFix(const TAuxServerSettings& auxServerSettings) noexcept;

        void OnPriority(const TPriority& prio) noexcept;

        [[nodiscard]] TMaybe<TPriority> OnResponse(const THeaders& respHeaders) noexcept;

        [[nodiscard]] bool IsEnabled() const noexcept;

    private:
        const TAuxServerSettings& Settings_;
        bool MaybeEdge_ = true;
    };
}
