#pragma once

#include "http2_flow.h"
#include "http2_headers.h"

namespace NSrvKernel::NHTTP2 {

    class TStreamInput final : public TStreamId {
    public:
        enum class EState {
            Open, Closed, Cancelled
        };

        explicit TStreamInput(TStreamId streamId, const TBaseProperties& reqProps, IConnection& conn) noexcept;

        void PrintTo(IOutputStream& out) const;

        [[nodiscard]] bool IsOpen() const noexcept {
            return EState::Open == State_;
        }

        [[nodiscard]] bool IsClosed() const noexcept {
            return EState::Closed == State_;
        }

        TError OnData(TFrame frame) noexcept;

        TError Close() noexcept;

        void Cancel() noexcept;

        TErrorOr<TChunkList> DequeueData(TInstant deadline) noexcept;

    private:
        TLogger& Logger_;
        TStats& Stats_;
        TConnOutput& Output_;

        TStreamRecvFlow Flow_;
        TContExecutor& Executor_;
        ui64 WindowUpdate_ = 0;

        TChunkList Buffer_;
        TCoroSingleCondVar EmptyBufferCV_;
        TMaybe<ui64> ContentLength_;
        ui64 RecvLength_ = 0;

        EState State_ = EState::Open;
    };
}
