#pragma once

#include <library/cpp/logger/log.h>

#include <util/datetime/base.h>
#include <util/generic/buffer.h>
#include <util/generic/string.h>
#include <util/system/thread.h>


namespace NSrvKernel {
    class TSystemLog: public TLog {
    public:
        TSystemLog();

        TSystemLog(THolder<TLogBackend> backend) : TLog(std::move(backend)) {};

        TSystemLog(const TString& name) {
            Open(name);
        }

        void Open(const TString& path);

        template <class T>
        TLogElement operator<<(const T& t) {
            TLogElement ret(this);

            LogPrefix(ret);
            ret << t;

            return ret;
        }

    private:
        void LogPrefix(TLogElement& s);

        pid_t Tid_ = TThread::CurrentThreadNumericId();
    };
}
