#pragma once

#include <balancer/kernel/module/iface.h>

using namespace NConfig;

namespace NSrvKernel {

    template<class T>
    struct IMatcher : public IConfig::IFunc {
        virtual void Init(IWorkerCtl*) {}
        [[nodiscard]] virtual bool Match(const T& target) const noexcept = 0;
        [[nodiscard]] virtual bool NeedsHttp() const noexcept {return false;}
    };


    // TODO(velavokr): simply have two functions instead of template specs.
    template<class T>
    THolder<IMatcher<T>> ConstructSpecMatcher(const TString& key, NConfig::IConfig* config, ICtl* ctl);
}
