#include "chunk.h"

#include <util/stream/output.h>

using namespace NSrvKernel;

template <>
void Out<TChunk>(IOutputStream& out, const TChunk& chunk) {
    out.Write(chunk.Data(), chunk.Length());
}

namespace {
    size_t CalcChunkLength(size_t base = 2 * NSystemInfo::GetPageSize()) {
        if (base <= sizeof(TChunkData) + sizeof(size_t)) {
            return 1;
        }

        return base - sizeof(TChunkData) - sizeof(size_t);
    }
}

size_t TChunk::DefaultLength = CalcChunkLength();

void TChunk::SetDefaultLengthBase(size_t base) {
    DefaultLength = CalcChunkLength(base);
}

void TChunk::ResetDefaultLengthBase() {
    DefaultLength = CalcChunkLength();
}


