#pragma once

#include "conn_descr.h"

#include <util/stream/output.h>

namespace NSrvKernel {
    class TConnDescr;
    class IModule;

    class TExtraAccessLogEntry: public TNonCopyable {
    public:
        TExtraAccessLogEntry(const TConnDescr& descr, TStringBuf label) noexcept
            : TExtraAccessLogEntry(descr.ExtraAccessLog, label)
        {}

        TExtraAccessLogEntry(TAccessLogOutput out, TStringBuf label) noexcept
            : Out_(out)
#ifdef BALANCER_DEBUG
            , Start_(Now())
            , CommonStart_(descr.Properties->Start)
#endif
        {
            Before(label);
        }


        ~TExtraAccessLogEntry() noexcept {
            After();
        }

    private:
        void Before(TStringBuf label) const noexcept {
            try {
                Out_ << " [" << label;
            } catch (...) {
            }
        }

        void After() const noexcept {
            try {
#ifdef BALANCER_DEBUG
                const TInstant now = Now();
                Out_ << ' ' << now - Start_ << '/' << now - CommonStart_ << ']';
#else
                Out_ << ']';
#endif
            } catch (...) {
            }
        }

    private:
        TAccessLogOutput Out_;
#ifdef BALANCER_DEBUG
        const TInstant Start_;
        const TInstant CommonStart_;
#endif
    };
}
