#include "module.h"

#include <util/system/tls.h>

namespace {
    Y_THREAD(THolder<THashSet<TString>>) printedByThread;
    Y_THREAD(NSrvKernel::TConstructingList) constructingList;
}

NSrvKernel::TConstructingList& NSrvKernel::TConstructingList::Instance() {
    return constructingList.Get();
}

NSrvKernel::TPrintOnceScope::TPrintOnceScope() {
    printedByThread.Get() = MakeHolder<THashSet<TString>>();
}

NSrvKernel::TPrintOnceScope::~TPrintOnceScope() {
    printedByThread.Get().Destroy();
}

void NSrvKernel::PrintOnce(TString message) {
    message = StripString(message);
    auto& printed = printedByThread.Get();
    if (!printed) {
        Cerr << message << Endl;
    } else if (!printed->contains(message)) {
        Cerr << message << Endl;
        printed->insert(message);
    }
}
