#include <balancer/kernel/testing/module_mock.h>
#include <balancer/kernel/testing/process_mock.h>
#include <balancer/kernel/testing/node_handle_mock.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NSrvKernel;

using ::testing::Return;
using ::testing::ReturnRef;
using ::testing::Ref;
using ::testing::Invoke;

Y_UNIT_TEST_SUITE(TBasicUnittest) {
    constexpr char STRING_SAMPLE[] = "Some string";

    Y_UNIT_TEST(NodeHandleMockTest) {
        NSrvKernel::NTesting::TNodeHandleMock<TString> nhm;

        TString nameSample{"SomeName"};

        // Name()
        // --------------------------------------------------------------------------------
        EXPECT_CALL(nhm, DoName())
            .Times(1)
            .WillOnce(ReturnRef(nameSample));

        UNIT_ASSERT_EQUAL(nhm.Name(), nameSample);
        // --------------------------------------------------------------------------------


        TModuleParams params;

        // Construct()
        // --------------------------------------------------------------------------------
        EXPECT_CALL(nhm, DoConstruct(Ref(params)))
            .Times(1)
            .WillOnce(Return(new TString{STRING_SAMPLE}));

        auto strHolder = nhm.Construct(params);
        UNIT_ASSERT_VALUES_EQUAL(strHolder->c_str(), STRING_SAMPLE);
        // --------------------------------------------------------------------------------
    }

    Y_UNIT_TEST(ModuleMockTest) {
        NSrvKernel::NTesting::TModuleMock moduleMock;

        // Handle()
        // --------------------------------------------------------------------------------
        EXPECT_CALL(moduleMock, DoHandle())
            .Times(1)
            .WillOnce(Return(nullptr));

        UNIT_ASSERT_EQUAL(moduleMock.GetHandle(), nullptr);
        // --------------------------------------------------------------------------------


        // Init()
        // --------------------------------------------------------------------------------
        EXPECT_CALL(moduleMock, DoInit(nullptr))
            .Times(1);

        moduleMock.Init(nullptr);
        // --------------------------------------------------------------------------------


        // CheckConstraints()
        // --------------------------------------------------------------------------------
        EXPECT_CALL(moduleMock, DoCheckConstraints())
            .Times(1);

        moduleMock.CheckConstraints();
        // --------------------------------------------------------------------------------


        // Finalize()
        // --------------------------------------------------------------------------------
        EXPECT_CALL(moduleMock, DoFinalize())
            .Times(1);

        moduleMock.Finalize();
        // --------------------------------------------------------------------------------


        // Dispose()
        // --------------------------------------------------------------------------------
        EXPECT_CALL(moduleMock, DoDispose(nullptr))
            .Times(1);

        moduleMock.Dispose(nullptr);
        // --------------------------------------------------------------------------------


        // ExtraAccessLog()
        // --------------------------------------------------------------------------------
        EXPECT_CALL(moduleMock, DoExtraAccessLog())
            .Times(1)
            .WillOnce(Return(true));

        UNIT_ASSERT_EQUAL(moduleMock.ExtraAccessLog(), true);
        // --------------------------------------------------------------------------------


        // EventHandler()
        // --------------------------------------------------------------------------------
        EXPECT_CALL(moduleMock, DoEventHandler())
            .Times(1)
            .WillOnce(Return(nullptr));

        UNIT_ASSERT_EQUAL(moduleMock.EventHandler(), nullptr);
        // --------------------------------------------------------------------------------
    }
}
