#pragma once

#include "address.h"

namespace NSrvKernel {
    struct THostFormat {
        THostFormat(const NAddr::IRemoteAddr* addr) noexcept
            : Addr(addr)
        {}

        const NAddr::IRemoteAddr* const Addr = nullptr;
    };

    inline THostFormat FormatHost(const NAddr::IRemoteAddr& addr) noexcept {
        return THostFormat(&addr);
    }

    inline THostFormat FormatHost(const NAddr::IRemoteAddr* addr) noexcept {
        return THostFormat(addr);
    }
}
