#pragma once

#include "stats.h"
#include <balancer/kernel/pinger/backend_info_helper.h>

#include <util/datetime/base.h>

namespace NSrvKernel {
    class IBackendPinger {
    public:
        virtual TBackendStatus Ping() = 0;
        virtual TDuration Delay() const = 0;
        virtual void ProcessPingResult(const TBackendStatus& status) = 0;
        virtual void LoadCounters(TPingerStatsCounters* counters) = 0;
        virtual ~IBackendPinger() = default;
    };
}
