#pragma once

#include "backend_pinger.h"

#include <balancer/kernel/fs/shared_files.h>

#include <util/generic/ptr.h>

namespace NSrvKernel {
    class IPingerBackendGroupManager {
    public:
        virtual ~IPingerBackendGroupManager() = default;
        virtual void AddPinger(TString name, THolder<IBackendPinger> pinger) = 0;
        virtual ui64 GetTheOldestPingTime() const = 0;
    };

    class IPingerManager {
    public:
        virtual ~IPingerManager() = default;
        virtual THolder<IPingerBackendGroupManager> GeneratePingerBackendGroupManager() = 0;
    };
}
