#pragma once

#include <balancer/kernel/stats/manager.h>

namespace NSrvKernel {
    struct TPingerStatsCounters {
        TPingerStatsCounters(
            TSharedCounter total,
            TSharedCounter succ,
            TSharedCounter fail,
            TSharedCounter badStatus,
            TSharedCounter zeroWeightStatus,
            TSharedCounter parseFail,
            TSharedCounter connRefused,
            TSharedCounter connTimeout,
            TSharedCounter connOtherError,
            TSharedHistogram pingsHist,
            TSharedCounter degraded
        )
            : TotalPingsCounter(std::move(total))
            , SuccessfulPingsCounter(std::move(succ))
            , ConnectionFailedPingsCounter(std::move(fail))
            , BadStatusPingsCounter(std::move(badStatus))
            , ZeroWeightPingsCounter(std::move(zeroWeightStatus))
            , ParseFailedPingsCounter(std::move(parseFail))
            , ConnectionRefusedPingsCounter(std::move(connRefused))
            , ConnectionTimeoutPingsCounter(std::move(connTimeout))
            , ConnectionOtherErrorPingsCounter(std::move(connOtherError))
            , DelayOfPingsHistogram(std::move(pingsHist))
            , DegradedPingsCounter(std::move(degraded))
            {}
        TSharedCounter TotalPingsCounter;
        TSharedCounter SuccessfulPingsCounter;
        TSharedCounter ConnectionFailedPingsCounter;
        TSharedCounter BadStatusPingsCounter;
        TSharedCounter ZeroWeightPingsCounter;
        TSharedCounter ParseFailedPingsCounter;
        TSharedCounter ConnectionRefusedPingsCounter;
        TSharedCounter ConnectionTimeoutPingsCounter;
        TSharedCounter ConnectionOtherErrorPingsCounter;
        TSharedHistogram DelayOfPingsHistogram;
        TSharedCounter DegradedPingsCounter;
    };
}
