#pragma once

#include <balancer/kernel/pinger/common/pinger_manager_face.h>
#include <balancer/kernel/pinger/common/backend_pinger.h>
#include <balancer/kernel/pinger/common/stats.h>

#include <balancer/kernel/coro/coroutine.h>
#include <balancer/kernel/stats/manager.h>

#include <library/cpp/containers/flat_hash/flat_hash.h>
#include <library/cpp/coroutine/engine/impl.h>

#include <util/generic/map.h>
#include <util/generic/maybe.h>
#include <util/generic/vector.h>
#include <util/generic/string.h>

namespace NSrvKernel {
    class TPingerBackendGroupManager : public IPingerBackendGroupManager {
    public:
        TPingerBackendGroupManager(TContExecutor* executor, TPingerStatsCounters* counters);

        void AddPinger(TString name, THolder<IBackendPinger> pinger) override;
        ui64 GetTheOldestPingTime() const override;

    private:
        void UpdatePingTimeOfBackend(const TString& backendName, ui64 pingTime);

        TContExecutor* Executor_ = nullptr;

        TVector<THolder<IBackendPinger>> Pingers_;
        NFH::TFlatHashMap<TString, ui64> LastPingTimeOfBackends_;
        TMap<ui64, ui16> PingTimeCount_;

        TPingerStatsCounters* Counters_ = nullptr;

        TVector<TCoroutine> PingerContsList_;
    };
}
