#include "pinger_backend_group_manager.h"
#include "pinger_backend_manager.h"
#include <balancer/kernel/pinger/common/stats.h>

#include <util/stream/output.h>

namespace NSrvKernel {
    TPingerManager::TPingerManager(TContExecutor* executor, TPingerStatsCounters* counters)
        : Executor_(executor)
        , StatsCounters_(counters)
    {}

    THolder<IPingerBackendGroupManager> TPingerManager::GeneratePingerBackendGroupManager() {
        return MakeHolder<TPingerBackendGroupManager>(Executor_, StatsCounters_);
    }
}
