#pragma once

#include <balancer/kernel/pinger/common/backend_pinger.h>

#include <balancer/kernel/fs/shared_files.h>
#include <balancer/kernel/log/log.h>
#include <balancer/kernel/pinger/common/pinger_manager_face.h>
#include <balancer/kernel/pinger/common/stats.h>
#include <balancer/kernel/thread/threadedqueue.h>

#include <library/cpp/coroutine/engine/impl.h>

#include <util/generic/map.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>

namespace NSrvKernel {
    class TPingerBackendGroupManager;

    class TPingerManager : public IPingerManager {
    public:
        TPingerManager(TContExecutor* executor, TPingerStatsCounters* counters);

        THolder<IPingerBackendGroupManager> GeneratePingerBackendGroupManager() override;

    private:
        TContExecutor* Executor_ = nullptr;
        TPingerStatsCounters* StatsCounters_;
    };
}
