#pragma once

#include <balancer/kernel/ctl/ctl.h>
#include <balancer/kernel/http/parser/http.h>
#include <balancer/kernel/regexp/regexp_re2.h>

namespace NSrvKernel::NProcessCore {

    class TMainTask;
    class TMasterProcess;

    class TAdminManager {
    public:
        explicit TAdminManager(TMasterProcess& masterProcess);

        TError MakeAdminAnswer(IIoInput* input, IIoOutput* output) noexcept;

    private:
        bool TriggerGracefulShutdown(TEventData& event, const TRequestLine& request, TChunksOutputStream& out) const noexcept;

        bool TriggerReloadConfig(TEventData& event, const TRequestLine& request, TChunksOutputStream& out) const noexcept;

        bool ExtractEvent(TStringBuf uri, TStringBuf& command, TStringBuf& event) const noexcept;

    private:
        TMasterProcess& MasterProcess_;
        TRegexp EventsRegexp_;
    };
}
