#pragma once

#include <balancer/kernel/ctl/ctl.h>
#include <balancer/kernel/process/config_check.h>
#include <balancer/kernel/process/main_config.h>
#include <balancer/kernel/process/main_event_handler.h>
#include <balancer/kernel/module/module_face.h>

namespace NSrvKernel::NProcessCore {
    class TMainTask;
    class TMainEventHandler;

    class TBaseProcess
        : public IWorkerCtl
        , public IDisposable
    {
    public:
        TBaseProcess(size_t workerId, TMainTask& mainTask)
            : IWorkerCtl(workerId)
            , MainTask_(mainTask)
            , EventHandler_(MakeHolder<TMainEventHandler>())
        {}

        void SetShuttingDown() {
            ShuttingDown_ = true;
        }

        void SetBlockNewRequests() noexcept {
            BlockNewRequests_ = true;
        }

        virtual void Execute() = 0;

        bool IsShuttingDown() const noexcept final {
            return ShuttingDown_;
        }

        bool BlockNewRequests() const noexcept final {
            return BlockNewRequests_;
        }

        const TBackendCheckOverridenParameters& BackendCheckOverrides() override;

        TEventHandler* EventHandler() const noexcept override;

    protected:
        TMainTask& MainTask_;
    private:
        bool ShuttingDown_ = false;
        bool BlockNewRequests_ = false;
        TMaybe<TBackendCheckOverridesReReader> BackendCheckOverridesUpdater;
        THolder<TMainEventHandler> EventHandler_;
    };
}
