#pragma once

#include <balancer/kernel/process/base_process.h>
#include <balancer/kernel/process/master_main.h>
#include <balancer/kernel/process/messages.h>

#include <balancer/kernel/coro/coroutine.h>
#include <balancer/kernel/ctl/ctl.h>

#include <balancer/kernel/pinger/pinger_backend_manager.h>
#include <balancer/kernel/ctl/children_process_common.h>
#include <balancer/kernel/process/children_common/process_stat.h>
#include <balancer/kernel/process_common/main_options.h>
#include <balancer/kernel/connection_manager_helpers/helpers.h>
#include <balancer/kernel/connection_manager/connection_pool.h>
#include <balancer/kernel/connection_manager/connection_manager.h>
#include <util/thread/factory.h>

namespace NSrvKernel {
namespace NDns {
class THelper;
}

namespace NProcessCore {
class TMainStats;

    class TConnectionManagerProcess
        : public TBaseProcess
    {
    public:
        void Execute() override;
        //void BusyLoop();
        void RecvLoop();
        void Stop();
        void CleanKeepalives();

        TSharedFiles* SharedFiles() noexcept override;
        TThreadedQueue* ThreadedQueue(const TString& name) noexcept override;
        TPingerManager& SharedPingerManager() noexcept override;
        NDns::IResolver& Resolver() noexcept final;
        TLog* GetLog(const TString&) override;
        TLog* GetDynamicBalancingLog() override;
        NProcessCore::TChildProcessType WorkerType() const noexcept override;
        TContExecutor& Executor() const noexcept override {
            return Executor_->Executor();
        }

        void DumpSharedFiles(NJson::TJsonWriter&) override {}
        void AddGracefulShutdownHandler(IGracefulShutdownHandler*, bool) override {}

        void DoDispose() noexcept override;

        TConnectionManagerProcess(TMainTask& task, const TMainOptions& options, TW2WChannel<TM2CMessage>& m2cChannel,
                NConnectionManager::TConnectionManager* connectionManager);
        ~TConnectionManagerProcess();

    public:
        THolder<TOwnExecutor> Executor_;

    private:
        THolder<TMainStats> MainStats_;
        THolder<TWorkerCpuStat> WorkerCpuStat_;
        TW2WChannel<TM2CMessage>& M2CChannel_;

        TContextSafeLog<TSystemLog> ConnectionManagerLog_;

        NConnectionManager::TConnectionManager* ConnectionManager_;
        TCoroutine CpuMeasureCoroutine_;
        TCoroutine RecvLoop_;
        THolder<NConnectionManager::TConnectionManager::TRuntime> Runtime_;
    };
}}
