#pragma once

#include <balancer/kernel/process/base_process.h>
#include <balancer/kernel/process/master_main.h>
#include <balancer/kernel/process/messages.h>

#include <balancer/kernel/ctl/children_process_common.h>

#include <balancer/kernel/process/children_common/process_stat.h>

#include <balancer/kernel/coro/coroutine.h>
#include <balancer/kernel/ctl/ctl.h>

#include <util/thread/factory.h>


namespace NSrvKernel {
namespace NDns {
class THelper;
}

namespace NProcessCore {

class TUpdaterProcess
    : public TBaseProcess
{
public:
    TUpdaterProcess(TMainTask& task, const TMainOptions& options, TW2WChannel<TM2CMessage>& m2cChannel);
    ~TUpdaterProcess() override;

    void Execute() override;
    void RecvLoop();
    void FuncExecution();
    void Stop();

    TSharedFiles* SharedFiles() noexcept override;
    TThreadedQueue* ThreadedQueue(const TString& name) noexcept override;
    TPingerManager& SharedPingerManager() noexcept override;
    TLog* GetLog(const TString&) override;
    TLog* GetDynamicBalancingLog() override;
    NProcessCore::TChildProcessType WorkerType() const noexcept override;
    NDns::IResolver& Resolver() noexcept final;
    TContExecutor& Executor() const noexcept override {
        return Executor_->Executor();
    }

    void DumpSharedFiles(NJson::TJsonWriter&) override {};
    void AddGracefulShutdownHandler(IGracefulShutdownHandler*, bool) override {}

    void DoDispose() noexcept override;

public:
    THolder<TOwnExecutor> Executor_;

private:
    THolder<TMainStats> MainStats_;
    THolder<TWorkerCpuStat> WorkerCpuStat_;
    NSrvKernel::NDynamicBalancing::TUpdaterManager& Updater_;
    TW2WChannel<TM2CMessage>& M2CChannel_;
    THolder<NDns::TStatsCounters> DnsCounters_;
    THolder<TSharedFiles> SharedFiles_;

    IThreadFactory* ThreadPool_ = SystemThreadFactory();
    TThreadedQueueList ThreadedQueueList_;

    TContextSafeLog<TSystemLog> Log_;
    TContextSafeLog<TSystemLog> DynamicBalancingLog_;

    TCoroutine CpuMeasureCoroutine_;
    TCoroutine RecvLoopTask_;
    TCoroutine FuncExecutionCont_;
    THolder<NDns::THelper> DnsHelper_;
};

}}
