#pragma once

#include "util/datetime/base.h"
#include <balancer/kernel/log/log.h>
#include <balancer/kernel/log/logbackend.h>

#include <cstddef>
#include <library/cpp/coroutine/engine/callbacks.h>

namespace NSrvKernel::NProcessCore {

    class TWorkerScheduleCallback final
        : public NCoro::IScheduleCallback
    {
    public:
        TWorkerScheduleCallback(TDuration contExecutionTimeLogThreshold, TContextSafeLog<TSystemLog>& log)
            : ContExecutionTimeLogThreshold_(contExecutionTimeLogThreshold)
            , Log_(log) {}

        void OnSchedule(TContExecutor&, TCont& cont) override {
            CurrentContName_ = cont.Name();
            CurrentContStartTime_ = Now();
        }

        void OnUnschedule(TContExecutor&) override {
            auto executionTime = Now() - CurrentContStartTime_;
            if (executionTime > ContExecutionTimeLogThreshold_) {
                Log_ << "Execution cont " << CurrentContName_ << " " << executionTime << Endl;
            }
        }

    private:
        TDuration ContExecutionTimeLogThreshold_;
        TContextSafeLog<TSystemLog>& Log_;
        const char* CurrentContName_ = nullptr;
        TInstant CurrentContStartTime_;
    };
}
