#pragma once

#include <balancer/kernel/ctl/ctl.h>
#include <balancer/kernel/module/module_face.h>
#include <library/cpp/logger/log.h>
#include <util/stream/file.h>
#include <util/stream/format.h>

#define Y_LOG_STDERR(marker) Cerr << RightPad(marker, 8)

namespace NSrvKernel {
    struct TBackendCheckParameters {
        TMaybe<double> Quorum;
        TMaybe<double> Hysteresis;
        TMaybe<size_t> AmountQuorum;
        TMaybe<size_t> AmountHysteresis;
        TString SectionName;
    };

    struct TBackendCheckOverridenParameters {
        TMaybe<TBackendCheckParameters> Global;
        TMap<TString, TBackendCheckParameters> Sections;
        size_t Id = 0;
    };

    namespace NProcessCore {
        class TMainTask;

        struct TBackendGroup {
            TString Name;
            IModule *Mod = nullptr;

            TBackendGroup(TString name, IModule *mod)
                    : Name(name), Mod(mod) {}
        };

        class TBackendCheckOverridesReReader {
        public:
            TBackendCheckOverridesReReader(IWorkerCtl &process, const TString &fileName);

            const TBackendCheckOverridenParameters &Current();

        private:
            TSharedFileReReader ReReader_;
            TBackendCheckOverridenParameters Overrides_;
        };

        struct TConfigCheck : public IConfig::IFunc {
            TMainTask *MainTask = nullptr;
            TString FileName;
            bool SkipSameGroups = true;

        public:
            TConfigCheck(TMainTask *mainTask)
                    : MainTask(mainTask) {}

            START_PARSE
                ON_KEY("quorums_file", FileName) {
                    return;
                }
                ON_KEY("skip_same_groups", SkipSameGroups) {
                    return;
                }
            END_PARSE

            THolder<TCoroutine> Start(IWorkerCtl &ctl, TVector<TBackendGroup> &groups);
        };
    }
}
