#pragma once

#include <library/cpp/coroutine/listener/listen.h>
#include <library/cpp/coroutine/engine/impl.h>
#include <balancer/kernel/net/address.h>
#include <balancer/kernel/module/conn_descr.h>

namespace NSrvKernel::NProcessCore {
    class TConnection;
    class TWorkerProcess;

    class IConnectionCallback {
    public:
        TWorkerProcess* WorkerProcess_ = nullptr;
        size_t InProgr_ = 0;
        TAtomic* TotalConnectionInProgress_ = nullptr;

        IConnectionCallback(TWorkerProcess* workerProcess, TAtomic* totalConnectionInProgress = nullptr) {
            WorkerProcess_ = workerProcess;
            TotalConnectionInProgress_ = totalConnectionInProgress;
        }

        virtual void UpPriority(TConnection* conn) noexcept = 0;
        virtual void AddCanceled(const NAddr::IRemoteAddr& addr) noexcept = 0;
    };
}
