#pragma once

#include <balancer/kernel/process/initializer.pb.h>
#include <balancer/kernel/memory/chunk.h>

namespace NSrvKernel {
    TChunkPtr SerializeMessage(const TInitializerMessage&);
    TInitializerMessage DeserializeMessage(const char*, size_t);

    const TInitializerMessage& ReloadSuccessful();
    const TInitializerMessage& ReloadInProgress();
    TInitializerMessage ReloadFailed(const TString& error);
    const TInitializerMessage& GetReloadState();
    TInitializerMessage ShutdownMaster(TShutdownMaster::EShutdownReason reason);
    const TInitializerMessage& CancelReload();
    const TInitializerMessage& OldMasterExited();
    const TInitializerMessage& OldMasterClosedUnistat();
    const TInitializerMessage& HealthMessage();

    bool IsReloadCompleted(const TReloadState& state);
}
