#pragma once

#include "worker_connection_callback.h"

#include <balancer/kernel/module/iface.h>

#include <library/cpp/coroutine/listener/listen.h>

namespace NSrvKernel::NProcessCore {
    class TWorkerProcess;

    class TListener : public TContListener::ICallBack {
    public:
        TWorkerProcess* WorkerProcess_;
        TWorkerConnectionCallback WorkerConnectionCallback_;
        const IModule& Module;

        TListener(TWorkerProcess* workerProcess, const IModule& module, TAtomic* totalConnectionInProgress)
            : WorkerProcess_(workerProcess)
            , WorkerConnectionCallback_(workerProcess, totalConnectionInProgress)
            , Module(module)
        {}

        void OnAcceptFull(const TAcceptFull&) override;
        void OnError() override;
        void OnStop(TSocketHolder*) override;
    };
}
