#pragma once

#include <balancer/kernel/dns/dns_helper.h>
#include <balancer/kernel/net/address.h>
#include <balancer/kernel/net/config_addrs.h>
#include <balancer/kernel/net/sockops.h>
#include <balancer/kernel/net/socket.h>
#include <balancer/kernel/log/logbackend.h>


namespace NSrvKernel::NProcessCore {
    struct TMainConfig {
        TConfigAddresses AdminAddrs;
        TString LogName;
        TString DynamicBalancingLogName;
        TString UnifiedAgentLogName;
        TString ConfigTag;
        TString ConfigString;
        TString TcpCongestionControlName;
        TMaybe<int32_t> TcpNotsentLowat;

        TDuration WorkerStartDuration = TDuration::Seconds(30);
        TDuration WorkerStartDelay = TDuration::Seconds(1);

        size_t Buffer = 32 * 1024;
        size_t MaxConnections = 0;
        size_t MaxStatsConnections = 10;
        size_t MaxAdminConnections = 10;
        size_t SoSndbuf = 0;
        size_t NChildren = 1;
        size_t TempBufPrealloc = 0; // for term only, avoid page faults when load increases

        TMaybe<size_t> CoroStackSize;
        bool CoroStackGuard = false;
        bool CoroPoolAllocator = false;
        NCoro::NStack::TPoolAllocatorSettings CoroPoolSettings;

        TSockBufSize SockBufSize;
        TTcpKeepalive TcpKeepalive{
                .Cnt = 6,
                .Idle = 59,
                .Intvl = 10,
        };
        int TcpListenQueue = 32768;
        bool CoroFailOnError = true;
        bool TcpRstOnError = true;

        TChildProcessMask ChildrenMask;

        TLogQueueOpts LogQueueOpts;

        bool ShutdownAcceptConnections = false;
        bool ShutdownCloseUsingBPF = false;
        bool Watchdog = true;
        bool SetNoFile = true;

        NDns::THelperConfig Dns;

        TString BackendsBlacklistFile;

        bool StartWithoutSpecialChildren = false;

        bool P0fEnabled = false;
        size_t P0fMapMaxSize = 100000;

        TString BanAddressesDisableFile_ = "./controls/disable_antirobot_ban_by_source_ip";
        size_t BanAddressesMaxCount_ = 1000000;
    };
}
