#pragma once

#include <balancer/kernel/coro/waked.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/generic/variant.h>

namespace NSrvKernel {
    struct TEvent {
        TString Event;
        bool JsonOut = false;
        TAtomicSharedPtr<TW2WChannel<TString>> OutputChannel;

        TString ToString() const {
            TString retval;
            TStringOutput out(retval);
            out << "TEvent(" << Event;
            if (JsonOut) {
                out << ", json";
            }
            out << ")";
            return retval;
        }
    };

    struct TListEvents {
        TAtomicSharedPtr<TW2WChannel<TVector<TString>>> OutputChannel;

        TString ToString() const {
            return "TListEvents()";
        }
    };

    struct TShutDown {
        TDuration CoolDown;
        TDuration Timeout;
        TDuration CloseTimeout;
        bool SkipBlockRequests = false;

        TString ToString() const {
            TString retval;
            TStringOutput out(retval);
            out << "TShutDown(CoolDown=" << CoolDown << ", Timeout=" << Timeout << ", CloseTimeout=" << CloseTimeout
                << ", SkipBlockRequests=" << SkipBlockRequests << ')';
            return retval;
        }
    };

    struct TResetDnsCache {
        TString ToString() const {
            return "TResetDnsCache()";
        }
    };

    struct TWorkerReady {
        TString ToString() const {
            return "TWorkerReady()";
        }
    };

    using TM2CMessage = std::variant<TEvent, TShutDown, TResetDnsCache, TListEvents>;
    using TC2MMessage = std::variant<TWorkerReady>;
}
