#pragma once

#include <balancer/kernel/helpers/common_parsers.h>

#include <util/generic/hash.h>


namespace NSrvKernel {

namespace NDns {
class IAsyncSimpleResolver;
}

namespace NProcessCore {

class TResolveHelper final {
    using THosts = THashMap<TString, TString>;
public:
    TResolveHelper(TDuration resolveTimeout);
    ~TResolveHelper();

    void StartResolve(NConfig::IConfig& parser, int family);
    void WaitForResults() const;

    const THosts* GetHosts() const noexcept { return &HostToIp_; }

private:
    void ParseIpDispatch(NConfig::IConfig& parser);
    void ParseProxy(NConfig::IConfig& parser);

private:
    THosts HostToIp_;
    TDuration ResolveTimeout_;
    TInstant ResolveStart_;
    THolder<NDns::IAsyncSimpleResolver> Resolver_;
};

}}