#pragma once

#include <util/network/poller.h>
#include <util/network/pollerimpl.h>

#include <util/datetime/base.h>

namespace NSrvKernel {
    // epoll() syscalls family does not work fine with fork()s:
    // an event may fire in any of processes on the same epfd, even when
    // which may lead to bugs in event handling, so
    // here we introduce an explicitly select()-based poller.
    // It could have been a poll() based tool, but current util's impl
    // does not have one, and the main use of this class is in TInitializerManager,
    // so there is no difference.
    class TSelectPoller {
    public:
        TSelectPoller() = default;

        void WaitRead(SOCKET sock, void* cookie);
        void WaitWrite(SOCKET sock, void* cookie);

        void Unwait(SOCKET sock);

        void* WaitI();

    private:
        using TImpl = TGenericPoller<::TSelectPoller<TWithoutLocking>>;

    private:
        TImpl Impl_;
    };
}
