#pragma once

#include <balancer/kernel/memory/chunks.h>
#include <library/cpp/coroutine/engine/impl.h>

#include <util/network/poller.h>
#include <util/stream/output.h>
#include <util/system/pipe.h>


namespace NSrvKernel {
    class TFixedBufferContReader {
    public:
        TFixedBufferContReader(char* buffer, size_t size)
                : Buffer_(buffer)
                , Remaining_(size)
        {}

        void ReadTheWholeThing(TCont*, SOCKET);
        static void ReadBuffer(TCont*, SOCKET, char* buffer, size_t size);

    private:
        char* Buffer_ = nullptr;
        size_t Scanned_ = 0;
        size_t Remaining_ = 0;
    };

    class TFixedBufferContWriter {
    public:
        explicit TFixedBufferContWriter(char* buffer, size_t size)
                : Buffer_(buffer)
                , Remaining_(size)
        {}

        void WriteTheWholeThing(TCont*, SOCKET);
        static void WriteBuffer(TCont*, SOCKET, char* buffer, size_t size);

    private:
        char* Buffer_ = nullptr;
        size_t Written_ = 0;
        size_t Remaining_ = 0;
    };
}
