#pragma once

#include <library/cpp/coroutine/engine/stack/stack_common.h>

#include <util/generic/maybe.h>
#include <util/generic/string.h>
#include <util/datetime/base.h>

namespace NSrvKernel {
    class TMainOptions {
    public:
        TMainOptions();

        size_t CoroStackSize() const noexcept {
            return CoroStackSize_.GetOrElse(DefaultCoroStackSize_);
        }

        void SetCoroStackSize(size_t stackSize) {
            CoroStackSize_ = stackSize;
        }

        bool TrySetCoroStackSize(size_t stackSize) {
            if (!CoroStackSize_) {
                CoroStackSize_ = stackSize;
                return true;
            }
            return false;
        }

    public:
        TString Poller;
        TDuration WorkerStartDelay = TDuration::Seconds(1);
        bool JustCheckConfig = false;
        bool SkipBackendChecks = false;
        bool SkipIpChecks = false;
        bool SkipExtendedChecks = false;
        bool JustDumpSignals = false;
        bool ReloadConfig = false;
        bool DebugInitializer = false;
        bool MemLock = false;
        bool CoroStackGuard = true;
        TMaybe<NCoro::NStack::TPoolAllocatorSettings> CoroPoolSettings;
        bool AllowEmptyAdminAddrs = false;
        TDuration ContExecutionTimeLogThreshold = TDuration::Zero();

    private:
        TMaybe<size_t> CoroStackSize_;
        static constexpr size_t DefaultCoroStackSize_ = 100 * 1024;
    };
}
