#include <balancer/kernel/process_common/two_nonblocking_pipe.h>

namespace NSrvKernel {
    TTwoNonblockingPipes::TTwoNonblockingPipes()
            : Input_()
            , Output_()
    {}

    TPipe& TTwoNonblockingPipes::Input() {
        return Input_;
    }

    TPipe& TTwoNonblockingPipes::Output() {
        return Output_;
    }

    void TTwoNonblockingPipes::Init() {
        SetNonBlock(Input_.GetHandle());
        SetNonBlock(Output_.GetHandle());
    }

    void TTwoNonblockingPipes::Close() {
        Input_.Close();
        Output_.Close();
    }
}
