#include "wait_pid.h"

#include <sys/wait.h>

namespace NSrvKernel {
    EWaitpidResult WaitPid(int pid, int* status) {
        if (waitpid(pid, status, WNOHANG) > 0) {
            return (WIFEXITED(*status) || WIFSIGNALED(*status)) ? EWaitpidResult::Dead : EWaitpidResult::Alive;
        }

        return EWaitpidResult::Alive;
    }

    EWaitpidResult WaitPid(int pid) {
        int status;

        return WaitPid(pid, &status);
    }
}
