#pragma once

#include <library/cpp/regex/pire/regexp.h>

namespace NSrvKernel {
    using TMatcher = NRegExp::TMatcher;
    using TFsm = NRegExp::TFsm;

    static inline TMatcher& Match(TMatcher& m, TStringBuf str) noexcept {
        return m.Match(str.data(), str.length());
    }

    static inline bool Match(const TFsm& fsm, TStringBuf str) noexcept {
        TMatcher matcher{ fsm };
        return Match(matcher, str).Final();
    }
}
