#include <balancer/kernel/regexp/regexp_pire.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TBalancerRegexpPireTest) {
    Y_UNIT_TEST(TestMatch) {
        using namespace NSrvKernel;
        {
            const TFsm fsm("a");

            UNIT_ASSERT(Match(fsm, "a"));
            UNIT_ASSERT(!Match(fsm, "aa"));
            UNIT_ASSERT(!Match(fsm, "A"));
            UNIT_ASSERT(!Match(fsm, "ab"));
            UNIT_ASSERT(!Match(fsm, "ba"));
        }
        {
            const TFsm fsm("[a-z]+");
            UNIT_ASSERT(Match(fsm, "a"));
            UNIT_ASSERT(Match(fsm, "ab"));
            UNIT_ASSERT(!Match(fsm, ""));
            UNIT_ASSERT(!Match(fsm, "Aa"));
            UNIT_ASSERT(!Match(fsm, "aA"));
        }
        {
            const TFsm fsm("[^a-z]+");
            UNIT_ASSERT(!Match(fsm, "a"));
            UNIT_ASSERT(!Match(fsm, "ab"));
            UNIT_ASSERT(!Match(fsm, ""));
            UNIT_ASSERT(!Match(fsm, "Aa"));
            UNIT_ASSERT(!Match(fsm, "aA"));
            UNIT_ASSERT(Match(fsm, "A"));
            UNIT_ASSERT(Match(fsm, "AA"));
        }
        {
            /*NB: these guys won't match: TFsm{"^ab"}, TFsm{"ab$"}, TFsm{"^ab$"}*/
            const TFsm fsm("ab");
            UNIT_ASSERT(Match(fsm, "ab"));
            UNIT_ASSERT(!Match(fsm, "a"));
            UNIT_ASSERT(!Match(fsm, ""));
            UNIT_ASSERT(!Match(fsm, {}));
        }
        {
            const TFsm fsm(
                TFsm("a", TFsm::TOptions().SetCaseInsensitive(true))
                | TFsm("b", TFsm::TOptions().SetCaseInsensitive(true))
            );
            UNIT_ASSERT(Match(fsm, "a"));
            UNIT_ASSERT(Match(fsm, "A"));
            UNIT_ASSERT(Match(fsm, "b"));
            UNIT_ASSERT(Match(fsm, "B"));
        }
    }

    Y_UNIT_TEST(TestInvalid) {
        using namespace NSrvKernel;
        UNIT_ASSERT_EXCEPTION(TFsm("("), NPire::TError);
    }
};
