#pragma once

#include "quota.h"

#include <balancer/kernel/module/module.h>

#include <library/cpp/config/sax.h>

#include <util/generic/hash.h>
#include <util/generic/ptr.h>

namespace NSrvKernel {
    class IModule;
}

namespace NSrvKernel::NRpsLimiter {
    struct TQuotaManager {
        THashMap<TString, THolder<IModule>> Remote;
        TQuotaState Storage;
        TString QuotaSyncPath;
        TDuration QuotaSyncInterval;
    };

    THolder<TQuotaManager> CreateQuotaManager(NConfig::IConfig& cfg, TInstant now);
}
