#include "rate.h"

#include <util/stream/output.h>

using namespace NSrvKernel;

template <>
void Out<NRpsLimiter::TLocalRate>(IOutputStream& out, const NRpsLimiter::TLocalRate& r) {
    out << "{.Prev=" << r.Prev()
        << ",.Curr=" << r.Curr()
        << ",.Time=" << r.Time().MicroSeconds()
        << ",.Window=" << r.Window().MicroSeconds() << "}";
}

template <>
void Out<NRpsLimiter::TPeerTime>(IOutputStream& out, const NRpsLimiter::TPeerTime& r) {
    out << "{.RemoteTime=" << r.RemoteTime.MicroSeconds()
        << ",.LocalTime=" << r.LocalTime.MicroSeconds() << "}";
}

template <>
void Out<NRpsLimiter::TPeerRate>(IOutputStream& out, const NRpsLimiter::TPeerRate& r) {
    out << "{.Window=" << r.Window().MicroSeconds()
        << ",.Rate=" << r.Rate() << "}";
}
