#include <balancer/kernel/rpslimiter/quota_manager.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NSrvKernel::NRpsLimiter;

Y_UNIT_TEST_SUITE(TQuotaManagerTest) {
    Y_UNIT_TEST(TestParseConfig) {
        const TString config = R"=(instance = {
    quotas = {
        --[[intervals are in ms]]--
        ["namespace1-quota"] = { quota = 1.1; interval = 1100; };
        ["namespace2-quota"] = { quota = 2.2; interval = 2200; };
    };
    remote = {
        local_host_id = "self";
        sync_path = "/state.sync.1";
        sync_interval = "200ms";
        ["self"] = {
            proxy = {
                host = "localhost"; port = port;
                connect_timeout = "1s"; backend_timeout = "1s"; resolve_timeout = "1s";
            };
        };
        ["peer"] = {
            proxy = {
                host = "localhost"; port = peer_port;
                connect_timeout = "1s"; backend_timeout = "1s"; resolve_timeout = "1s";
            };
        };
    };
    module = {
        errordocument = { status = 404; };
    }; -- module
}; -- rpslimiter_instance)=";
        const auto now = TInstant::Seconds(1607434128);
        TStringInput sin(config);
        auto res = CreateQuotaManager(*NConfig::ConfigParser(sin), now);
        UNIT_ASSERT(res);
        UNIT_ASSERT_VALUES_EQUAL(res->QuotaSyncPath, "/state.sync.1");
        UNIT_ASSERT_VALUES_EQUAL(res->QuotaSyncInterval, TDuration::MilliSeconds(200));
        UNIT_ASSERT(res->Remote.contains("self"));
        UNIT_ASSERT(res->Remote.contains("peer"));
        UNIT_ASSERT_VALUES_EQUAL(res->Storage.SelfName(), "self");
        UNIT_ASSERT(res->Storage.QuotaIdx("namespace1-quota"));
        UNIT_ASSERT(res->Storage.QuotaIdx("namespace2-quota"));
        UNIT_ASSERT(res->Storage.PeerIdx("peer"));
        UNIT_ASSERT_VALUES_EQUAL(res->Storage.QuotaInfo(*res->Storage.QuotaIdx("namespace1-quota")), (TQuota{
            .Name="namespace1-quota",
            .Start=now,
            .Window=TDuration::MilliSeconds(1100),
            .Limit=1.1f,
        }));
        UNIT_ASSERT_VALUES_EQUAL(res->Storage.QuotaInfo(*res->Storage.QuotaIdx("namespace2-quota")), (TQuota{
            .Name="namespace2-quota",
            .Start=now,
            .Window=TDuration::MilliSeconds(2200),
            .Limit=2.2f,
        }));
    }
}
