#include "srcrwr_addrs.h"

#include <util/random/random.h>

namespace NSrvKernel::NSrcrwr {

void TAddrs::SetAddrs(TVector<TAddr> addrs) {
    Addrs_ = std::move(addrs);
    if (Addrs_.empty()) {
        Next_ = 0;
        return;
    }
    Next_ = RandomNumber<ui64>() % Addrs_.size();
}

bool TAddrs::GetNextAddr(TString& host, TString& ip, TIpPort& port) {
    bool res = GetAddr(host, ip, port);

    if (++Next_ >= Addrs_.size()) {
        Next_ = 0;
    }

    return res;
}

bool TAddrs::GetAddr(TString& host, TString& ip, TIpPort& port) {
    if (Addrs_.empty()) {
        host.clear();
        ip.clear();
        port = 0;
        return false;
    }

    host = Addrs_[Next_].Host;
    ip = Addrs_[Next_].Ip;
    port = Addrs_[Next_].Port;

    return true;
}

bool TAddrs::Empty() const {
    return Addrs_.empty();
}

}
